package coreservlets.tags;

import java.io.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import coreservlets.listeners.*;

/**
 * Klasa InitialCompanyNameListener posiada metody statyczne, ktre
 * udostpniaj aktualn i poprzedni nazw firmy. Lecz aby mc
 * uy tych metod na stronach JSP, potrzebny jest jawny kod Java,
 * a gdyby informacje miay by udostpniane przez utworzone w tym celu
 * komponenty JavaBean, obsuga wynikw ich dziaania byaby niewygodna.
 * Dlatego kod zosta przeniesiony do wasnego znacznika.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class CompanyNameTag extends SimpleTagSupport {
  public void doTag() throws JspException, IOException {
    PageContext pageContext = (PageContext) getJspContext();
    ServletContext context = pageContext.getServletContext();
    String companyName = 
      InitialCompanyNameListener.getCompanyName(context);
    JspWriter out = pageContext.getOut();
    out.print(companyName);
  }
}
